
#include <msp430.h>
#include "hal_pmm.h"
#include "hal_UCS.h"

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// user define
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// timer clock
#define FrequenzaDiClock        24969216                                        // Hz
#define SamplePeriod            7803;                                           // internal clock period = 1/25MHz Timer break every ~312.5us 64 samples per wave @50Hz 
#define Period_1ms              24969;                                          // internal clock period = 1/25MHz Timer break every 1ms  

// ADC - IDC
#define N_Campionamenti         128
#define N_Campioni              (N_Campionamenti - 1)
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

unsigned int FirstADCVal;                       // Holds 1st ADC result


int main( void )
{
  // Stop watchdog timer to prevent time out reset
  WDTCTL = WDTPW + WDTHOLD;

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  SetVCore(3);                                                                  //  tensione alimentazione del core: level 3
  //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  
  //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  // Setup LFXT1
  //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  #define MCLK_DEF 25   /* 25 MHz */
  UCSCTL6_L |= XT1DRIVE1_L+XT1DRIVE0_L;                                         // Highest drive setting for XT1 startup
  // Loop until XT1 fault flag is cleared
  while (SFRIFG1 & OFIFG) {                                                     // check OFIFG fault flag
    UCSCTL7 &= ~(DCOFFG+XT1LFOFFG+XT2OFFG);                                     // Clear OSC flaut Flags fault flags
    SFRIFG1 &= ~OFIFG;                                                          // Clear OFIFG fault flag
  }
  UCSCTL6 = (UCSCTL6 & ~(XT1DRIVE_3)) |(XT1DRIVE_3); // set Drive mode

  //Init_FLL_Settle(MCLK_DEF*8388608/8/1000, MCLK_DEF*32768*32/32768);
  Init_FLL_Settle(MCLK_DEF*8388608/8/1000, MCLK_DEF*32768*32/34400);            //      __debug da sistemare routine di inizializzazione
  /* There seems no benefit in waiting for the FLL to settle at this point. */
  //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  // Setup TA0
  //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  TA0CCTL0 = CCIE;                                                              // CCR0 interrupt enabled
  TA0CCR0 = SamplePeriod;                                                       // period = 1/25MHz Timer break every ~312.5us 64 samples per wave @50Hz 
  TA0CTL = TASSEL_2 | MC_1 | TACLR;                                             // SMCLK, upmode, clear TAR
 
//  TA0CCR1 = 3900; 
//  TA0CCTL1 = OUTMOD_4 ;                                                           // abilitazione per Timer1_A1  
//  TA0CTL = TASSEL_2 | MC_1 | TACLR ;                                    // SMCLK, upmode, clear TAR, enable interrupt     __debug
  //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ 

  
    
  //############################################################################  
  // port debug
  //############################################################################  
  P4DIR |= BIT7;                                // Set P4.7 to output direction
  P4OUT &= ~BIT7;                               // Clear P4.7
  //############################################################################  

  
  
    

  //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  // Setup SD24_B
  //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  
  SD24BCTL0 = SD24REFS | SD24SSEL_1 | SD24PDIV_2 | SD24DIV1;                    // Select internal REF, SMCLK as SD24_B clock source, Frequency pre-scaler  /(3*4)  [Fm = 2MHz]

  SD24BINCTL0   =       SD24GAIN_1 | SD24INTDLY_1;                              // Select GAIN = 1, Interrupt Delay: Int. after 3.Conversion
  SD24BINCTL1   =       SD24GAIN_1 | SD24INTDLY_1;                              // 
  SD24BINCTL2   =       SD24GAIN_1 | SD24INTDLY_1;                              // 
  
  SD24BCCTL0    =       SD24DF_1  | SD24SCS_4 | SD24SNGL;                       // Data Format: 2's complement, Start Conversion Select: 4
  SD24BCCTL1    =       SD24DF_1  | SD24SCS_4 | SD24SNGL;;                      // 
  SD24BCCTL2    =       SD24DF_1  | SD24SCS_4 | SD24SNGL;;                      // 
  
  SD24BPRE0     =       0;                                                      // 
  SD24BPRE1     =       0;                                                      // 
  SD24BPRE2     =       0;                                                      // 

  SD24BOSR0 = 64-1;
  SD24BOSR1 = 64-1;
  SD24BOSR2 = 64-1;
  
  SD24BIE |= SD24IE0 | SD24IE1 | SD24IE2;                                       // Enable channels 0, 1, 2 interrupt
  //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



  //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  //****************************************************************************
  //    SetUp Analog ADC10
  //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  //****************************************************************************
  P1SEL1 |= BIT2 | BIT3 | BIT4 | BIT5;                                          // Set Analog Port Input
  P1SEL0 |= BIT2 | BIT3 | BIT4 | BIT5;                                          // Set Analog Port Input

  while (REFCTL0 & REFGENBUSY) ;                                                // If ref generator busy, WAIT
  REFCTL0 |= REFVSEL_2 | REFON;                                                 // Reference Voltage Level Select 2.5V
  
  ADC10CTL0 &= ~ADC10ENC; 
  
  ADC10CTL0 |= ADC10SHT_2 | ADC10MSC | ADC10ON;                                 // 16ADCclks, MSC (Multiple SampleConversion), ADC ON    (6.5us tra i campionamenti - ~13us ritardo tra fase 1 e fase 3)
  // this is OK
  //ADC10CTL1 = ADC10SHP | ADC10CONSEQ_1 | ADC10SSEL_3 | ADC10DIV_5 | ADC10SHS_0; // pulse sample mode, single sequence, CLOCK select SMCLK /5 (freq.deve essere tra 0.45 e 5.5 MHz) select triggers ADC10SC bit
  // enable  ADC10SC on interrupt TIMER0_A0_ISR                                                         /
  
  // where am I wrong?
  ADC10CTL1 = ADC10SHP | ADC10CONSEQ_1 | ADC10SSEL_3 | ADC10DIV_5 | ADC10SHS_3;   // ????????????????
  //
   
  
  ADC10CTL2 |= ADC10RES;                                                        // 10-bit conversion results
  ADC10MCTL0 = ADC10INCH_5;                                                     // A2,A3,A4, A5(EoS), AVCC reference

  ADC10MCTL0 |= ADC10SREF_1;                                                    // VREF - AVSS
  ADC10IE |= ADC10IE0;                                                        // Enable ADC conv cmplete interrupt
  ADC10CTL0 |= ADC10ENC;                                              // Enable Conversion, Sampling and conversion start
  
  while (ADC10CTL1 & ADC10BUSY) ;                    // First conversion?
    FirstADCVal = ADC10MEM0;                           // Read out 1st ADC value
  //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



  
  __enable_interrupt();
  while (1)
  {
    __delay_cycles(5000);       
  }
  
}


